/* -LICENSE-START-
** Copyright (c) 2017 Blackmagic Design
**
** Permission is hereby granted, free of charge, to any person or organization
** obtaining a copy of the software and accompanying documentation covered by
** this license (the "Software") to use, reproduce, display, distribute,
** execute, and transmit the Software, and to prepare derivative works of the
** Software, and to permit third-parties to whom the Software is furnished to
** do so, all subject to the following:
**
** The copyright notices in the Software and this entire statement, including
** the above license grant, this restriction and the following disclaimer,
** must be included in all copies of the Software, in whole or in part, and
** all derivative works of the Software, unless such copies or derivative
** works are solely in the form of machine-executable object code generated by
** a source language processor.
**
** THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
** IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
** FITNESS FOR A PARTICULAR PURPOSE, TITLE AND NON-INFRINGEMENT. IN NO EVENT
** SHALL THE COPYRIGHT HOLDERS OR ANYONE DISTRIBUTING THE SOFTWARE BE LIABLE
** FOR ANY DAMAGES OR OTHER LIABILITY, WHETHER IN CONTRACT, TORT OR OTHERWISE,
** ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
** DEALINGS IN THE SOFTWARE.
** -LICENSE-END-
*/

#ifndef BMD_VT_DECODE_SESSION_H__
#define BMD_VT_DECODE_SESSION_H__

#include <VideoToolbox/VideoToolbox.h>
#include <list>

#include "DeckLinkAPI.h"

class VTDecodeDelegate
{
public:
	virtual void haveVideoFrame(CVPixelBufferRef pixBuf, IBMDStreamingH264NALPacket* fromNAL) =0;
	virtual ~VTDecodeDelegate() {}
};

class VTDecodeSession
{
public:
	VTDecodeSession();
	~VTDecodeSession();

	void setDelegate(VTDecodeDelegate* delegate);
	void handleH264NAL(IBMDStreamingH264NALPacket* nal);

private:
	bool startDecompressionSession();
	void decompressFrame();
	void clearNalsFrameList();
	void decompressionCompleteWithResult(OSStatus result,
										VTDecodeInfoFlags flags,
										CVPixelBufferRef pixBuf);
	static void videoDecompressed(void* vtDecodeSession,
								void* sourceFrameRefCon,
								OSStatus result,
								VTDecodeInfoFlags flags,
								CVImageBufferRef pixBuf,
								CMTime time,
								CMTime duration);

	VTDecodeDelegate*			m_delegate;
	uint64_t					m_hostTimeScale;
	VTDecompressionSessionRef	m_session;
	CMVideoFormatDescriptionRef	m_videoFormatDescription;
	bool						m_needsSPS;
	bool						m_needsPPS;
	bool						m_needsIDR;
	bool						m_nalDecompressed;
	CVPixelBufferRef			m_pixBuf;

	typedef std::list<IBMDStreamingH264NALPacket*> NalsFrameList;
	NalsFrameList 				m_NALsForOneFrame;
	size_t						m_NALsForOneFrameTotalSize;

	IBMDStreamingH264NALPacket*	m_firstSPS;
	IBMDStreamingH264NALPacket*	m_firstPPS;
	IBMDStreamingH264NALParser*	m_nalParser;
};

#endif /* BMD_VT_DECODE_SESSION_H__ */